IF EXISTS ( SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_EST_PROD_COD_BENEF_CARGA' )
BEGIN
	DROP TRIGGER TRG_EST_PROD_COD_BENEF_CARGA
END
GO

CREATE TRIGGER TRG_EST_PROD_COD_BENEF_CARGA
ON
EST_PROD_COD_BENEF AFTER INSERT, DELETE, UPDATE
AS
UPDATE EST_PROD_CPL SET DT_ATUALIZA_PARAM = GETDATE() 
FROM INSERTED EST_PROD_COD_BENEF
INNER JOIN GLB_CID ON
	EST_PROD_COD_BENEF.UF = GLB_CID.UF COLLATE SQL_Latin1_General_CP1_CI_AS
INNER JOIN PRC_FILIAL ON
	GLB_CID.CD_CID = PRC_FILIAL.CD_CID
INNER JOIN EST_PROD_CPL ON
	EST_PROD_COD_BENEF.CD_EMP = EST_PROD_CPL.CD_EMP
	AND EST_PROD_COD_BENEF.CD_PROD = EST_PROD_CPL.CD_PROD
	AND PRC_FILIAL.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
